IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC]') 
					AND type in (N'U')) 
BEGIN
 
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	SET ANSI_PADDING ON

	CREATE TABLE [dbo].[EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC](

		[CD_EMP] [int] NOT NULL CONSTRAINT [DF_EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC_CD_EMP]  DEFAULT ((0)),
	 	[CD_AGD_RESSUP] [int] NOT NULL CONSTRAINT [DF_EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC_CD_AGD_RESSUP] DEFAULT ((0)),
		[CD_FILIAL_DEPO] [int] NOT NULL CONSTRAINT [DF_EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC_CD_FILIAL_DEPO] DEFAULT ((0)),
		[CD_FABRIC] [int] NOT NULL CONSTRAINT [DF_EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC_CD_FABRIC]  DEFAULT ((0)), 

	 CONSTRAINT [PK_EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC] PRIMARY KEY CLUSTERED 
	(	[CD_EMP] ASC , 
		[CD_AGD_RESSUP]  ASC,
		[CD_FILIAL_DEPO] ASC,
		[CD_FABRIC] ASC   )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, 
	ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY]

	SET ANSI_PADDING OFF 

	ALTER TABLE [dbo].[EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC]  WITH CHECK 
		ADD  CONSTRAINT [FK_EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC_EST_PROD_RESSUP_AGENDAMENTO] FOREIGN KEY([CD_EMP],[CD_FILIAL_DEPO], [CD_AGD_RESSUP])
	REFERENCES [dbo].[EST_PROD_RESSUP_AGENDAMENTO] ([CD_EMP],[CD_FILIAL_DEPO], [CD_AGD_RESSUP]) 

	ALTER TABLE [dbo].[EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC] CHECK CONSTRAINT [FK_EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC_EST_PROD_RESSUP_AGENDAMENTO]

	
	ALTER TABLE [dbo].[EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC]  WITH CHECK 
		ADD  CONSTRAINT [FK_EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC_EST_PROD_FABRIC] FOREIGN KEY(CD_FABRIC)
	REFERENCES [dbo].[EST_PROD_FABRIC] (  [CD_FABRIC]) 

	ALTER TABLE [dbo].[EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC] CHECK CONSTRAINT [FK_EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC_EST_PROD_FABRIC]

 END
